

program testsortmod

  ! This module uses quicksort to sort arrays (in place) or to return
  ! an index vector. It can sort vectors or 2-D arrays. In the latter
  ! case

  use sortmod

  implicit none

  call test_sortmod()

contains




!================================================================================
subroutine test_sortmod()
!================================================================================

  use knuth

  integer :: n, i, j, seed, k
  integer, dimension(:), pointer :: a, idx
  real,    dimension(:), pointer :: r
  real(8), dimension(:), pointer :: d

  integer, dimension(:,:), pointer :: b
  real,    dimension(:,:), pointer :: br
  real(8), dimension(:,:), pointer :: bd

  real :: t1, t2, tolr
  real(8) :: told, td1, td2

  nullify( a, idx, r, d )

  n = 100000

  print *
  print *, 'sorting list of n = ', n, ' elements...'

  allocate( a(n), idx(n), r(n), d(n) )
  call random_number( r )
  a = nint( r * 1.0D6 )
 
  call argsort( n, a, idx )
  do i = 1, n-1
     if ( a(idx(i)) > a(idx(i+1)) ) then
        print *, 'argsort, integer NOT OK!'
        goto 977
     end if
  end do
  print *, 'argsort, integer       ok'

  call sort( n, a )
  do i = 1, n-1
     if ( a(i) > a(i+1) ) then
        print *, 'sort, integer NOT OK!'
        goto 977
     end if
  end do
  print *, 'sort, integer          ok'

  call argsort( n, r, idx )
  do i = 1, n-1
     if ( r(idx(i)) > r(idx(i+1)) ) then
        print *, 'argsort, real NOT OK!'
        goto 977
     end if
  end do
  print *, 'argsort, real          ok'

  call sort( n, r )
  do i = 1, n-1
     if ( r(i) > r(i+1) ) then
        print *, 'sort, real NOT OK!'
        goto 977
     end if
  end do
  print *, 'sort, real             ok'

  call random_number( d )
  call argsort( n, d, idx )
  do i = 1, n-1
     if ( d(idx(i)) > d(idx(i+1)) ) then
        print *, 'argsort, double NOT OK!'
        goto 977
     end if
  end do
  print *, 'argsort, double        ok'

  call sort( n, d )
  do i = 1, n-1
     if ( d(i) > d(i+1) ) then
        print *, 'sort, double NOT OK!'
        goto 977
     end if
  end do
        print *, 'sort, double           ok'

  ! multi-dim case
  allocate( b(3,n) )
  do i = 1, 3
     call random_number( r )
     b(i,:) = nint( r*50. )
  end do

  call argsort( n, 3, b, idx )

  do i = 1, n-1
     if ( cmp_le( b(:,idx(i+1)), b(:,idx(i)), 3 ) ) then
        print *, b(:,idx(i))
        print *, b(:,idx(i+1))
        print *, 'argsort, mDim, integer NOT OK!'
        goto 977
     end if
  end do
  print *, 'argsort, mDim, integer ok'
  call sort( n, 3, b )
  do i = 1, n-1
     if ( cmp_le( b(:,i+1), b(:,i), 3 ) ) then
        print *, b(:,i)
        print *, b(:,i+1)
        print *, 'sort, mDim, integer NOT OK!'
        goto 977
     end if
  end do
  print *, 'sort, mDim, integer    ok'

  ! real
  allocate( br(3,n) )
  call random_number( br )
  tolr = 1.0e-6
  
  call argsort( n, 3, br, idx )
  do i = 1, n-1
     if ( cmp_le( br(:,idx(i+1)), br(:,idx(i)), 3 ) ) then
        print *, br(:,idx(i))
        print *, br(:,idx(i+1))
        print *, 'argsort, mDim, real NOT OK!'
        goto 977
     end if
  end do 
  print *, 'argsort, mDim, real    ok'

  call sort( n, 3, br )
  do i = 1, n-1
     if ( cmp_le( br(:,i+1), br(:,i), 3 ) ) then
        print *, br(:,i)
        print *, br(:,i+1)
        print *, 'sort, mDim, real NOT OK!'
        goto 977
     end if
  end do
  print *, 'sort, mDim, real       ok'

  ! double
  allocate( bd(3,n) )
  seed = 121
  call randomize( seed )
  do i = 1, n
     do j = 1, 3
        bd(j,i) = rRan()
     end do
  end do
  told = 1.0D-12
  
  call argsort( n, 3, bd, idx )
  do i = 1, n-1
     if ( cmp_le( bd(:,idx(i+1)), bd(:,idx(i)), 3 ) ) then
        print *, bd(:,idx(i))
        print *, bd(:,idx(i+1))
        print *, 'argsort, mDim, double NOT OK!'
        goto 977
     end if
  end do 
  print *, 'argsort, mDim, double  ok'

  call sort( n, 3, bd )
  do i = 1, n-1
     if ( cmp_le( bd(:,i+1), bd(:,i), 3  ) ) then
        print *, bd(:,i)
        print *, bd(:,i+1)
        print *, 'sort, mDim, double NOT OK!'
        goto 977
     end if
  end do
  print *, 'sort, mDim, double     ok'

977 continue
  deallocate( a, idx, r, d, b, br, bd )


  print *
  ! speed test
  n = 10000000
  print *, 'sorting lists of n = ', n, ' elements...'

  allocate( d(n) )
  do i = 1, n
     d(i) = rRan()
  end do
  call cpu_time( t1 )
  call sort( n, d )
  call cpu_time( t2 )
  print *, 'double vector, elapsed = ', t2 - t1

  ! sort a sorted array
  call cpu_time( t1 )
  call sort( n, d )
  call cpu_time( t2 )
  print *, 'already sorted double vector, elapsed = ', t2 - t1 

  ! sort an array with many equal values
  k = 1
  do i = 1, n/100
     d(k:k+99) = rRan()
     k = k + 100
  end do
  call cpu_time( t1 )
  call sort( n, d )
  call cpu_time( t2 )
  print *, 'double vector with many equal values, elapsed = ', t2 - t1   
  deallocate( d )


  allocate( b(3,n) )
  do i = 1, n
     do j = 1, 3
        b(j,i) = iRan()
     end do
  end do
  call cpu_time( t1 )
  call sort( n, 3, b )
  call cpu_time( t2 )
  print *, 'multidimensional integer array, elapsed = ', t2 - t1   
  deallocate( b )


end subroutine test_sortmod


end program testsortmod
